/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.globe;

import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeTextureGenerator;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncGlobeDataPacket;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class GlobeData
extends class_18 {
    public static final class_9139<class_9129, GlobeData> STREAM_CODEC = new class_9139<class_9129, GlobeData>(){

        public GlobeData decode(class_9129 buf) {
            int len = buf.method_10816();
            byte[][] pixels = new byte[len][];
            for (int i = 0; i < len; ++i) {
                pixels[i] = buf.method_10795();
            }
            long seed = buf.readLong();
            return new GlobeData(pixels, seed);
        }

        public void encode(class_9129 buf, GlobeData data) {
            buf.method_10804(data.globePixels.length);
            for (byte[] pixels : data.globePixels) {
                buf.method_10813(pixels);
            }
            buf.method_52974(data.seed);
        }
    };
    private static final int TEXTURE_H = 16;
    private static final int TEXTURE_W = 32;
    public static final String DATA_NAME = "globe_data";
    private final byte[][] globePixels;
    private final long seed;
    private static GlobeData CLIENT_SIDE_INSTANCE = null;

    public GlobeData(byte[][] pixels, long seed) {
        this.globePixels = pixels;
        this.seed = seed;
    }

    private static GlobeData generate(long seed) {
        return new GlobeData(GlobeTextureGenerator.generate(seed), seed);
    }

    private static GlobeData load(class_2487 tag, class_7225.class_7874 provider) {
        byte[][] globePixels = new byte[32][16];
        for (int i = 0; i < 32; ++i) {
            globePixels[i] = tag.method_10547("colors_" + i);
        }
        long seed = tag.method_10537("seed");
        return new GlobeData(globePixels, seed);
    }

    public byte[][] getPixels() {
        return this.globePixels;
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 registries) {
        for (int i = 0; i < this.globePixels.length; ++i) {
            tag.method_10570("colors_" + i, this.globePixels[i]);
        }
        tag.method_10544("seed", this.seed);
        return tag;
    }

    public void sendToClient(class_1937 world) {
        this.method_80();
        if (!world.field_9236) {
            NetworkHelper.sendToAllClientPlayers((class_8710)new ClientBoundSyncGlobeDataPacket(this));
        }
    }

    @Nullable
    public static GlobeData get(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            return (GlobeData)world.method_8503().method_30002().method_17983().method_17924(new class_18.class_8645(() -> GlobeData.generate(server.method_8412()), GlobeData::load, null), DATA_NAME);
        }
        return CLIENT_SIDE_INSTANCE;
    }

    public static void recreateFromSeed(class_3218 level, long seed) {
        level.method_8503().method_30002().method_17983().method_123(DATA_NAME, (class_18)GlobeData.generate(seed));
    }

    public static void setClientData(GlobeData data) {
        CLIENT_SIDE_INSTANCE = data;
        GlobeManager.refreshTextures();
    }

    public static void sendDataToClient(class_3222 player) {
        GlobeData data = GlobeData.get(player.method_37908());
        if (data != null) {
            NetworkHelper.sendToClientPlayer((class_3222)player, (class_8710)new ClientBoundSyncGlobeDataPacket(data));
        }
    }
}

